/*
 * Copyright (c) 2005, 2006 Sharp Corporation
 */
#ifndef LNXDFBC_H_
#define LNXDFBC_H_

#include <sys/time.h>

#if !defined(XIMDFB_H_) && !defined(_SYSAPI_H_)
typedef unsigned int uint32;
typedef int int32;
typedef unsigned char uint8;
#endif
typedef void *dpucLnxDFBJpegData;

typedef struct {
	void *pdvAddr;
    uint32 uiWidth;
    uint32 uiHeight;
    uint32 uiPitch;
    uint8 ucIndex;
} dLnxDFBAddr_t;

typedef struct _dLnxDFBFont_t {
	int32 width;
	int32 height;
	int32 left;
	int32 top;
	int32 advance_x;
	int32 ascender;
	int32 descender;
	int32 max_advance;
	int32 fixed_advance;
	int32 pitch;
	int32 char_width;
	int32 char_height;
	void *bitmap;
} dLnxDFBFont_t;

/* sakakura begin */
typedef struct _dLnxDFBRect_t {
	uint32 uiX;
	uint32 uiY;
	uint32 uiWidth;
	uint32 uiHeight;
} dLnxDFBRegion_t;
/* sakakura end  */

typedef enum {
    LNXDFB_PNG_MOVE,  /* RGB Blend: off, Dest Alpha : the same value as src alpha */
    LNXDFB_JPEG_MOVE, /* RGB Blend: off, Dest Alpha : 0xff (always) */
    LNXDFB_PNG_DRAW,  /* RGB Blend: on (with src alpha), Dest Alpha : 0xff(always) */
    LNXDFB_RECT_DRAW, /* RGB Blend: on (with src alpha), Dest Alpha : the same value as dest alpha */
} dLnxDFBBlendType_e;


int32 iLnxDFBBlit (uint32 uiSrcX, uint32 uiSrcY, uint32 uiSrcWidth, uint32 uiSrcHeight, dLnxDFBAddr_t *ptSrc,
                   uint32 uiDestX, uint32 uiDestY, uint32 uiDestWidth, uint32 uiDestHeight, dLnxDFBAddr_t *ptDest,
                   dLnxDFBBlendType_e eBlendType, uint8 ucDestAlpha);

int32 iLnxDFBFill (uint32 uiX, uint32 uiY, uint32 uiWidth, uint32 uiHeight, dLnxDFBAddr_t *ptDest, uint32 uiColor);

int32 iLnxDFBFlip (uint32 uiX, uint32 uiY, uint32 uiWidth, uint32 uiHeight, dLnxDFBAddr_t *ptSrc);

int32 iLnxDFBDecodeJpeg (dLnxDFBAddr_t *ptDest, dpucLnxDFBJpegData pvpegData, size_t uiSize, const dLnxDFBRegion_t *ptcSrcRect, const dLnxDFBRegion_t *ptcDstRect);

int32 iLnxDFBReadJpeg (dpucLnxDFBJpegData pvpegData, uint32 uiSize, uint32 *puiWidth, uint32 *puiHeight);

int32 iLnxDFBInitPNG (void *pvPNGData, uint32 uiPNGDataLength, void **pvPNG, void **pvPNGInfo, uint32 *puiWidth, uint32 *puiHeight, int32 *piBpp, int32 *piColorType);

int32 iLnxDFBDecodePNG (void *pvPNG, void *pvPNGInfo, uint32 **puiImage, uint32 uiWidth, uint32 uiHeight);

int32 iLnxDFBCheckPNG (uint8 *pucHeader, size_t tSize);

int32 iLnxDFBInit (uint32 *puiWidth, uint32 *puiHeight);

int32 iLnxDFBInitYUV (dLnxDFBAddr_t *ptData);
int32 iLnxDFBInitYUVPortrait (dLnxDFBAddr_t *ptData);

int32 iLnxDFBInitPrimary (dLnxDFBAddr_t *ptData);
int32 iLnxDFBInitRotation (dLnxDFBAddr_t *ptData);

int32 iLnxDFBInitSub (dLnxDFBAddr_t *ptData);
int32 iLnxDFBInitSubPortrait (dLnxDFBAddr_t *ptData);

int32 iLnxDFBInitMainDisplay (dLnxDFBAddr_t *ptData);

int32 iLnxDFBExit (void);

int32 iLnxDFBReceiveEventMsg (int32 *piKey, int32 *piType, struct timeval *ptTimeval);

int32 iLnxDFBInitEventReceiver (void);
						
int32 iLnxDFBDeinitEventReceiver (void);

int32 iLnxDFBTranslateKey (int32 iKey);

int32 iLnxDFBGetKerning (dLnxDFBFont_t *face, int32 prev, int32 current, int32 *piX, int32 *piY);

int32 iLnxDFBSetFontSize (dLnxDFBFont_t *face, int32 iWidth, int32 iHeight);

int32 iLnxDFBGetFontGlyph (dLnxDFBFont_t *face, int32 iIndex);

int32 iLnxDFBGetFontInfo (dLnxDFBFont_t *face, int32 iIndex);

int32 iLnxIconvInit (void);

uint8 *pucLnxGetStdBufferAddr (void);

uint32 uiLnxGetStdBufferSize (void);

#ifdef ENABLE_STP_VOD
int32 iLnxDFBCheckDecodeAborted(void);

void  iLnxDFBAbortDecode(void);

void  iLnxDFBResetAbortDecode(void);

void  iLnxDFBRegisterAbortDecodeKey(int32 key);

int32  iLnxDFBGetAbortDecodeKey(void);

void vLnxDFBSetFillDstOpacity (uint8 ucAlpha);

uint8 ucLnxDFBGetFillDstOpacity (void);
#endif /* ENABLE_STP_VOD */

int32 iLnxDFBUnicodetoJIS (int32 iUnicode);

#endif /*LNXDFBC_H_*/
