/*
 * Copyright (c) 2005, 2006 Sharp Corporation
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <errno.h>
#include <limits.h>

#include <directfb.h>
#include <directfb_keynames.h>

#include <core/coredefs.h>
#include <core/coretypes.h>
#include <core/input.h>
#include <core/system.h>

#include <direct/debug.h>
#include <direct/mem.h>
#include <direct/thread.h>
#include <direct/messages.h>

#include <core/input_driver.h>

#include "shdfb.h"

#define CORE_SHDFB (CORE_VNC + 1)

DFB_INPUT_DRIVER (shdfb_input)

typedef struct _dSHDFBInputData_t {
	CoreInputDevice *ptDevice;
    DirectThread *ptThread;
	dSHDFB_t *ptSHDFB;
} dSHDFBInputData_t;

static int32 iSHDFBGetEvent (dSHDFBInputData_t *ptData) 
{
	DFBInputEvent tDFBEvent;
	int32 iKey, iType, iKeyID;
	struct timeval tTimeval;
	const int32 peEventType[] = {
		DIET_KEYPRESS,
		DIET_KEYPRESS,
		DIET_KEYRELEASE,
	};
		
	if (iLnxDFBReceiveEventMsg (&iKey, &iType, &tTimeval) < 0) {
		/* λ */ 
		return -1;
	}
	
	iKeyID = iLnxDFBTranslateKey (iKey);
	if (iKeyID < 0) {
		D_DEBUG ("%s: cannot translate key: %d\n", __FUNCTION__,  iKey);
		return 0;
	}
	D_DEBUG ("%s: key_id = %d, iType = %d\n", __FUNCTION__, tDFBEvent.key_id, iType);
	
	tDFBEvent.key_id = iKeyID;
	tDFBEvent.flags = DIEF_KEYID;
	tDFBEvent.type = peEventType[iType];
	tDFBEvent.key_code = tDFBEvent.key_id;
	tDFBEvent.timestamp = tTimeval;
	dfb_input_dispatch (ptData->ptDevice, &tDFBEvent);
		
	return 0;
}

static void *pvSHDFBInputThread (DirectThread *ptThread, void *pvDriverData )
{
	dSHDFBInputData_t *ptData = (dSHDFBInputData_t *) pvDriverData;
	dSHDFB_t *ptSHDFB = ptData->ptSHDFB;

	for (;;) {
     
        fusion_skirmish_prevail (&ptSHDFB->tLock );

		if (iSHDFBGetEvent (ptData) < 0) {
			fusion_skirmish_dismiss( &ptSHDFB->tLock );
			break;
		}
						
		fusion_skirmish_dismiss( &ptSHDFB->tLock );
#if 0
        direct_thread_testcancel( ptThread );
#endif
    }
    
    return NULL;
}

/* DirectFBɬפʴؿ̾ */
static int driver_get_available ()
{
	if (dfb_system_type () == CORE_SHDFB){
		return 1;
	}
	return 0;
}

/* DirectFBɬפʴؿ̾ */
static void driver_get_info (InputDriverInfo *ptInfo)
{
     snprintf (ptInfo->name, DFB_INPUT_DRIVER_INFO_NAME_LENGTH, "SHDFB Driver");

     snprintf (ptInfo->vendor, DFB_INPUT_DRIVER_INFO_VENDOR_LENGTH, "Sharp");

     ptInfo->version.major = 0;
     ptInfo->version.minor = 1;
}

/* DirectFBɬפʴؿ̾ */
static DFBResult driver_open_device (CoreInputDevice *ptDevice, uint32 uiNumber,  InputDeviceInfo *ptInfo, void **pDriverData)
{
     dSHDFBInputData_t *ptData;
     dSHDFB_t *ptSHDFB = dfb_system_data();
     
     fusion_skirmish_prevail (&ptSHDFB->tLock);
     fusion_skirmish_dismiss (&ptSHDFB->tLock);

     snprintf (ptInfo->desc.name, DFB_INPUT_DEVICE_DESC_NAME_LENGTH, "SHDFB Input");
     snprintf (ptInfo->desc.vendor, DFB_INPUT_DEVICE_DESC_VENDOR_LENGTH, "Sharp");
     ptInfo->prefered_id = DIDID_KEYBOARD;
     ptInfo->desc.type   = DIDTF_KEYBOARD;
     ptInfo->desc.caps   = DICAPS_ALL;

     ptData = D_CALLOC (1, sizeof (dSHDFBInputData_t));

     ptData->ptDevice = ptDevice;
     if (iLnxDFBInitEventReceiver () < 0) {
     	D_DEBUG ("%s: cannot init event receiver\n", __FUNCTION__);
     	return DFB_FAILURE;
     }
     ptData->ptSHDFB = ptSHDFB;
     ptData->ptThread = direct_thread_create (DTT_INPUT, pvSHDFBInputThread, ptData, "SHDFB Input");
     
     *pDriverData = ptData;

     return DFB_OK;
}

/* DirectFBɬפʴؿ̾ */
static DFBResult driver_get_keymap_entry (CoreInputDevice *ptDevice,
										                         void *pDriver_data,
										                         DFBInputDeviceKeymapEntry *ptEntry)
{
     return DFB_UNSUPPORTED;
}

/* DirectFBɬפʴؿ̾ */
static void driver_close_device (void *pDriver_data)
{
     dSHDFBInputData_t *ptData = (dSHDFBInputData_t *) pDriver_data;
     
     iLnxDFBDeinitEventReceiver ();
	 direct_thread_join (ptData->ptThread);
     
     D_FREE (ptData);
}

/* EOF */
