/*
 * Copyright (c) 2005, 2006 Sharp Corporation
 */

#include <config.h>

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <directfb.h>

#include <fusion/arena.h>

#include <core/core.h>
#include <core/coredefs.h>
#include <core/coretypes.h>
#include <core/layers.h>
#include <core/surfaces.h>
#include <core/system.h>

#include <gfx/convert.h>

#include <misc/conf.h>

#include <direct/mem.h>
#include <direct/messages.h>

#include <sys/types.h>

#include "shdfb.h"
#include "shdfb_system_primary.h"

#include <core/core_system.h>

DFB_CORE_SYSTEM (shdfb)

dSHDFB_t *ptSHDFB      = NULL;
CoreDFB *ptSHDFBCore = NULL;

#define CORE_SHDFB (CORE_VNC + 1)

static void
system_get_info (CoreSystemInfo *ptInfo)
{
    ptInfo->type = CORE_SHDFB;	
    ptInfo->caps = CSCAPS_ACCELERATION;

    snprintf (ptInfo->name, DFB_CORE_SYSTEM_INFO_NAME_LENGTH, "SHDFB");
}

static DFBResult
system_initialize (CoreDFB *ptCore, void **pvData)
{
     int8 *pcDriver;
     CoreScreen *ptScreen;
     size_t size;

     D_ASSERT (ptSHDFB == NULL);

     ptSHDFB = (dSHDFB_t *) D_CALLOC (1, sizeof(dSHDFB_t));
     if (!ptSHDFB) {
          D_ERROR ("DirectFB/GLB: Couldn't allocate shared memory!\n");
          return DFB_NOSYSTEMMEMORY;
     }
     
     ptSHDFBCore = ptCore;

     fusion_skirmish_init (&ptSHDFB->tLock, "SHDFB System", dfb_core_world (ptCore) );

     ptScreen = dfb_screens_register (NULL, NULL, &tShdfbPrimaryScreenFuncs);

     dfb_layers_register (ptScreen, NULL, &tShdfbPrimaryLayerFuncs);

     fusion_arena_add_shared_field (dfb_core_arena (ptCore), "shdfb", ptSHDFB);
     
     *pvData = ptSHDFB;
     
     if (iLnxDFBInit (&ptSHDFB->uiWidth, &ptSHDFB->uiHeight) < 0) {
     	return DFB_FAILURE;
     }
     
     return DFB_OK;
}

static DFBResult
system_join (CoreDFB *ptCore, void **pvData)
{
     void *pvRet;
     CoreScreen *ptScreen;

     D_ASSERT (ptSHDFB == NULL);

     fusion_arena_get_shared_field (dfb_core_arena (ptCore), "shdfb", &pvRet);

     ptSHDFB = pvRet;
     ptSHDFBCore = ptCore;

     ptScreen = dfb_screens_register (NULL, NULL, &tShdfbPrimaryScreenFuncs);

     dfb_layers_register (ptScreen, NULL, &tShdfbPrimaryLayerFuncs);

     *pvData = ptSHDFB;

     return DFB_OK;
}

static DFBResult
system_shutdown (bool bEmergency)
{
    fusion_skirmish_prevail (&ptSHDFB->tLock);

    fusion_skirmish_destroy (&ptSHDFB->tLock);

    D_FREE (ptSHDFB);
    ptSHDFB = NULL;
    ptSHDFBCore = NULL;

    if (iLnxDFBExit () < 0) {
     	return DFB_FAILURE;
    }
    
    D_DEBUG ("%s: shutdown finished\n", __FUNCTION__);

    return DFB_OK;
}

static DFBResult
system_leave (bool bEmergency)
{
     D_ASSERT (ptSHDFB != NULL);

     ptSHDFB = NULL;
     ptSHDFBCore = NULL;

     return DFB_OK;
}

static DFBResult
system_suspend()
{
	return DFB_UNIMPLEMENTED;
}

static DFBResult
system_resume()
{
	return DFB_UNIMPLEMENTED;
}

static volatile void *
system_map_mmio (uint32 uiFOffset, int32 iLength)
{
    return NULL;
}

static void
system_unmap_mmio (volatile void  *addr, int32 iLength)
{
	D_ASSERT (true);
}

static int
system_get_accelerator()
{
     return 1;
}

static VideoMode *
system_get_modes()
{
     return NULL;
}

static VideoMode *
system_get_current_mode()
{
     return NULL;
}

static DFBResult
system_thread_init()
{
     return DFB_OK;
}

static bool
system_input_filter (CoreInputDevice *tDevice, DFBInputEvent *tEvent)
{
     return false;
}

static unsigned long
system_video_memory_physical (uint32 uiOffset)
{
     return 0;
}

static void *
system_video_memory_virtual (uint32 uiOffset)
{
	uint32 uiLength = DFB_BYTES_PER_LINE(SHDFB_FORMAT, ptSHDFB->uiWidth) * ptSHDFB->uiHeight;
	if (uiOffset > uiLength) {
		//uiOffset = uiLength - (uiOffset - uiLength);
		D_DEBUG ("%s %d\n", __FUNCTION__, uiOffset);
		return (void *) (((uint8 *) ptSHDFB->ptAddr[0]->pdvAddr) + uiOffset);
	} else {
		void *p;
		p = ptSHDFB->ptAddr[uiOffset]->pdvAddr;
		return p;
	}
}

static unsigned int
system_videoram_length ()
{
     return DFB_BYTES_PER_LINE(SHDFB_FORMAT, ptSHDFB->uiWidth) * ptSHDFB->uiHeight;
}

static void
system_get_busid (int32 *piRetBus, int32 *piRetDev, int32 *piRetFunc)
{
     return;
}

static void
system_get_deviceid (uint32 *puiRetVendorId, uint32 *puiRetDeviceId)
{
     return;
}
