/*
 * Copyright (c) 2005, 2006 Sharp Corporation
 */

#include "shdfb_gfx.h"

#include <core/system.h>

extern DisplayLayerFuncs  tShdfbOldPrimaryFuncs;
extern void *pShdfbOldPrimaryDriverData;

static DFBResult
shdfbYUVPortraitInitLayer (CoreLayer *ptLayer,
                    void *pDriver_data,
                    void *pLayer_data,
                    DFBDisplayLayerDescription *ptDescription,
                    DFBDisplayLayerConfig *ptConfig,
                    DFBColorAdjustment *ptAdjustment)
{
    DFBResult tRet;
    dShdfbDriverData_t *ptDriver = (dShdfbDriverData_t *) pDriver_data;
    int32 iRet = 0, iWidth;
	
    tRet = tShdfbOldPrimaryFuncs.InitLayer (ptLayer, pShdfbOldPrimaryDriverData, pLayer_data, ptDescription, ptConfig, ptAdjustment);
	if (tRet) {
		return tRet;
	}

	ptDescription->caps = DLCAPS_SURFACE;
    ptDescription->type = DLTF_GRAPHICS | DLTF_STILL_PICTURE;
    snprintf(ptDescription->name, DFB_DISPLAY_LAYER_DESC_NAME_LENGTH, "SHDFB YUV Portrait plane");

    ptDescription->caps |= DLCAPS_ALPHACHANNEL;
    ptConfig->pixelformat = YUV_PLANE_FORMAT;
	
#ifndef EMULATION
	if (ptDriver->tYUV_PAddr.pdvAddr == NULL) {  
            iRet = iLnxDFBInitYUVPortrait (&ptDriver->tYUV_PAddr);
	}
#else
	iRet = 0;
#endif    

   	ptConfig->width = ptDriver->tYUV_PAddr.uiWidth;
   	ptConfig->height = ptDriver->tYUV_PAddr.uiHeight;

    return iRet == 0 ? DFB_OK : DFB_FAILURE;
}

DFBResult
shdfbYUVPortraitAllocateSurface (CoreLayer *ptLayer,
								 void *pvDriverData,
								 void *pvLayerData,
								 void *pvRegionData,
								 CoreLayerRegionConfig *ptConfig,
								 CoreSurface **ptRetSurface)
{
    DFBResult tRet;
    dShdfbDriverData_t *ptDriver = (dShdfbDriverData_t *) pvDriverData;
    CoreSurface *ptSurface;
    
    tRet =  tShdfbOldPrimaryFuncs.AllocateSurface (ptLayer, pShdfbOldPrimaryDriverData, pvLayerData, pvRegionData, ptConfig, ptRetSurface);
    if (tRet) {
    	return tRet;
    }

    ptSurface = *ptRetSurface;

#ifndef EMULATION
    ptSurface->front_buffer->system.addr = (void *) &ptDriver->tYUV_PAddr;
    ptSurface->front_buffer->video.offset = 2;
#else
    ptSurface->front_buffer->system.addr = ptDriver->tYUV_PAddr.pdvAddr;
    fusion_reactor_attach (ptSurface->object.reactor, shdfbStopSurface, ptSurface, &ptDriver->reaction[ptDriver->reaction_num++]);
#endif    
    
    return DFB_OK;
}
	
DisplayLayerFuncs tShdfbYUVPortraitFuncs = {
    LayerDataSize:      shdfbYUVdatasize,
    InitLayer:          shdfbYUVPortraitInitLayer,
    SetRegion:          shdfbSetRegion,
    RemoveRegion:        shdfbRemoveRegion,
    TestRegion:         shdfbYUVTestRegion,
    AllocateSurface: shdfbYUVPortraitAllocateSurface,
    ReallocateSurface: shdfbReallocateSurface,
};
