/*
 * Copyright (c) 2005, 2006 Sharp Corporation
 */

#include "shdfb_gfx.h"

#include <core/system.h>

extern DisplayLayerFuncs  tShdfbOldPrimaryFuncs;
extern void *pShdfbOldPrimaryDriverData;

int shdfbYUVdatasize()
{
    return sizeof(dShdfbYUVData_t);
}

static DFBResult
shdfbYUVInitLayer (CoreLayer *ptLayer,
                    void *pDriver_data,
                    void *pLayer_data,
                    DFBDisplayLayerDescription *ptDescription,
                    DFBDisplayLayerConfig *ptConfig,
                    DFBColorAdjustment *ptAdjustment)
{
    DFBResult tRet;
    dShdfbDriverData_t *ptDriver = (dShdfbDriverData_t *) pDriver_data;
    int32 iRet = 0;
	
    tRet = tShdfbOldPrimaryFuncs.InitLayer (ptLayer, pShdfbOldPrimaryDriverData, pLayer_data, ptDescription, ptConfig, ptAdjustment);
	if (tRet) {
		return tRet;
	}

	ptDescription->caps = DLCAPS_SURFACE;
    ptDescription->type = DLTF_GRAPHICS | DLTF_STILL_PICTURE;
    snprintf(ptDescription->name, DFB_DISPLAY_LAYER_DESC_NAME_LENGTH, "SHDFB YUV plane");

    ptDescription->caps |= DLCAPS_ALPHACHANNEL;
    ptConfig->pixelformat = YUV_PLANE_FORMAT;
	
#ifndef EMULATION
	if (ptDriver->tYUV_LAddr.pdvAddr == NULL) {	
	    iRet = iLnxDFBInitYUV (&ptDriver->tYUV_LAddr);
	}
#endif    

   	ptConfig->width = ptDriver->tYUV_LAddr.uiWidth;
   	ptConfig->height = ptDriver->tYUV_LAddr.uiHeight;

    return iRet == 0 ? DFB_OK : DFB_FAILURE;
}

DFBResult
shdfbYUVTestRegion (CoreLayer *ptLayer,
                     void *pDriver_data,
                     void *pLayer_data,
                     CoreLayerRegionConfig      *ptConfig,
                     CoreLayerRegionConfigFlags *ptFailed)
{
    CoreLayerRegionConfigFlags tFail = 0;

    if (ptConfig->options)
        tFail |= CLRCF_OPTIONS;

    switch (ptConfig->format) {
          case YUV_PLANE_FORMAT:
              break;
          default:
              tFail |= CLRCF_FORMAT;
    }

    if (ptFailed) *ptFailed = tFail;
    if (tFail) return DFB_UNSUPPORTED;

    return DFB_OK;
}

DFBResult
shdfbYUVAllocateSurface (CoreLayer *ptLayer,
			                        void *pvDriverData,
			                        void *pvLayerData,
			                        void *pvRegionData,
			                        CoreLayerRegionConfig *ptConfig,
			                        CoreSurface **ptRetSurface)
{
    DFBResult tRet;
    dShdfbDriverData_t *ptDriver = (dShdfbDriverData_t *) pvDriverData;
    CoreSurface *ptSurface;
    
    tRet =  tShdfbOldPrimaryFuncs.AllocateSurface (ptLayer, pShdfbOldPrimaryDriverData, pvLayerData, pvRegionData, ptConfig, ptRetSurface);
    if (tRet) {
    	return tRet;
    }

    ptSurface = *ptRetSurface;

#ifndef EMULATION
    ptSurface->front_buffer->system.addr = (void *) &ptDriver->tYUV_LAddr;
    ptSurface->front_buffer->video.offset = 1;
#else
    ptSurface->front_buffer->system.addr = ptDriver->tYUV_LAddr.pdvAddr;
    fusion_reactor_attach (ptSurface->object.reactor, shdfbStopSurface, ptSurface, &ptDriver->reaction[ptDriver->reaction_num++]);
#endif    
    
    return DFB_OK;
}

DisplayLayerFuncs tShdfbYUVFuncs = {
    LayerDataSize:      shdfbYUVdatasize,
    InitLayer:          shdfbYUVInitLayer,
    SetRegion:          shdfbSetRegion,
    RemoveRegion:        shdfbRemoveRegion,
    TestRegion:         shdfbYUVTestRegion,
    AllocateSurface: shdfbYUVAllocateSurface,
    ReallocateSurface: shdfbReallocateSurface,
};
