/*
 * Copyright (c) 2005, 2006 Sharp Corporation
 */

#include "shdfb_gfx.h"

#include <core/system.h>

#define PORTRAIT_PLANE_FORMAT DSPF_ARGB

typedef struct _dShdfbRotationData_t {
	void *dummy;
} dShdfbRotationData_t;

extern DisplayLayerFuncs  tShdfbOldPrimaryFuncs;
extern void *pShdfbOldPrimaryDriverData;

static int shdfbRotationdatasize()
{
    return sizeof(dShdfbRotationData_t);
}

static DFBResult
shdfbRotationInitLayer (CoreLayer *ptLayer,
                    void *pDriver_data,
                    void *pLayer_data,
                    DFBDisplayLayerDescription *ptDescription,
                    DFBDisplayLayerConfig *ptConfig,
                    DFBColorAdjustment *ptAdjustment)
{
    DFBResult tRet;
    dShdfbDriverData_t *ptDriver = (dShdfbDriverData_t *) pDriver_data;
    int32 iRet, iWidth;
	
    tRet = tShdfbOldPrimaryFuncs.InitLayer (ptLayer, pShdfbOldPrimaryDriverData, pLayer_data, ptDescription, ptConfig, ptAdjustment);
	if (tRet) {
		return tRet;
	}

	ptDescription->caps = DLCAPS_SURFACE;
    ptDescription->type = DLTF_GRAPHICS | DLTF_STILL_PICTURE;
    snprintf(ptDescription->name, DFB_DISPLAY_LAYER_DESC_NAME_LENGTH, "SHDFB PORTRAIT plane");

    ptDescription->caps |= DLCAPS_ALPHACHANNEL;
    ptConfig->pixelformat = PORTRAIT_PLANE_FORMAT;
	

#ifndef EMULATION
	if (ptDriver->tRotationAddr.pdvAddr == NULL) {
		iRet = iLnxDFBInitRotation (&ptDriver->tRotationAddr);
	}
#else
	iRet = 0;
#endif    

   	ptConfig->width = ptDriver->tRotationAddr.uiWidth;
   	ptConfig->height = ptDriver->tRotationAddr.uiHeight;

    return iRet == 0 ? DFB_OK : DFB_FAILURE;
}

static DFBResult
shdfbRotationTestRegion (CoreLayer *ptLayer,
                     void *pDriver_data,
                     void *pLayer_data,
                     CoreLayerRegionConfig      *ptConfig,
                     CoreLayerRegionConfigFlags *ptFailed)
{
    CoreLayerRegionConfigFlags tFail = 0;

    if (ptConfig->options)
        tFail |= CLRCF_OPTIONS;

    switch (ptConfig->format) {
          case PORTRAIT_PLANE_FORMAT:
              break;
          default:
              tFail |= CLRCF_FORMAT;
    }

    if (ptFailed) *ptFailed = tFail;
    if (tFail) return DFB_UNSUPPORTED;

    return DFB_OK;
}

static DFBResult
shdfbRotationAllocateSurface (CoreLayer *ptLayer,
			                        void *pvDriverData,
			                        void *pvLayerData,
			                        void *pvRegionData,
			                        CoreLayerRegionConfig *ptConfig,
			                        CoreSurface **ptRetSurface)
{
    DFBResult tRet;
    dShdfbDriverData_t *ptDriver = (dShdfbDriverData_t *) pvDriverData;
    CoreSurface *ptSurface;
    
    tRet =  tShdfbOldPrimaryFuncs.AllocateSurface (ptLayer, pShdfbOldPrimaryDriverData, pvLayerData, pvRegionData, ptConfig, ptRetSurface);
    if (tRet) {
    	return tRet;
    }
    
    ptSurface = *ptRetSurface;

#ifndef EMULATION
    ptSurface->front_buffer->system.addr = (void *) &ptDriver->tRotationAddr;
	ptSurface->front_buffer->video.offset = 5;
#else
    ptSurface->front_buffer->system.addr = ptDriver->tRotationAddr.pdvAddr;	
	fusion_reactor_attach(ptSurface->object.reactor, shdfbStopSurface, ptSurface, &ptDriver->reaction[ptDriver->reaction_num++]);
#endif     
    
    return DFB_OK;
}

DisplayLayerFuncs tShdfbRotationFuncs = {
    LayerDataSize:      shdfbRotationdatasize,
    InitLayer:          shdfbRotationInitLayer,
    SetRegion:          shdfbSetRegion,
    RemoveRegion:        shdfbRemoveRegion,
    TestRegion:         shdfbRotationTestRegion,
    AllocateSurface: shdfbRotationAllocateSurface,
    ReallocateSurface: shdfbReallocateSurface,
};
