/*
 * Copyright (c) 2005, 2006 Sharp Corporation
 */

#include "shdfb_gfx.h"

#include <core/system.h>

#define MAIN_DISPLAY_PLANE_FORMAT DSPF_ARGB

typedef struct _dShdfbMainDisplayData_t {
	void *dummy;
} dShdfbMainDisplayData_t;

extern DisplayLayerFuncs  tShdfbOldPrimaryFuncs;
extern void *pShdfbOldPrimaryDriverData;

static int shdfbMainDisplaydatasize()
{
    return sizeof(dShdfbMainDisplayData_t);
}

static DFBResult
shdfbMainDisplayInitLayer (CoreLayer *ptLayer,
                    void *pDriver_data,
                    void *pLayer_data,
                    DFBDisplayLayerDescription *ptDescription,
                    DFBDisplayLayerConfig *ptConfig,
                    DFBColorAdjustment *ptAdjustment)
{
    DFBResult tRet;
    dShdfbDriverData_t *ptDriver = (dShdfbDriverData_t *) pDriver_data;
    int32 iRet;
	
    tRet = tShdfbOldPrimaryFuncs.InitLayer (ptLayer, pShdfbOldPrimaryDriverData, pLayer_data, ptDescription, ptConfig, ptAdjustment);
	if (tRet) {
		return tRet;
	}

	ptDescription->caps = DLCAPS_SURFACE;
    ptDescription->type = DLTF_GRAPHICS | DLTF_STILL_PICTURE;
    snprintf(ptDescription->name, DFB_DISPLAY_LAYER_DESC_NAME_LENGTH, "SHDFB Main Display plane");

    ptDescription->caps |= DLCAPS_ALPHACHANNEL;
    ptConfig->pixelformat = MAIN_DISPLAY_PLANE_FORMAT;
  
#ifndef EMULATION                          
    iRet = iLnxDFBInitMainDisplay (&ptDriver->tMainDisplayAddr);                      
#else
	iRet = 0;
#endif    

    ptConfig->width = ptDriver->tMainDisplayAddr.uiWidth;
    ptConfig->height = ptDriver->tMainDisplayAddr.uiHeight;

    return iRet == 0 ? DFB_OK : DFB_FAILURE;
}

static DFBResult
shdfbMainDisplayTestRegion (CoreLayer *ptLayer,
                     void *pDriver_data,
                     void *pLayer_data,
                     CoreLayerRegionConfig      *ptConfig,
                     CoreLayerRegionConfigFlags *ptFailed)
{
    CoreLayerRegionConfigFlags tFail = 0;

    if (ptConfig->options)
        tFail |= CLRCF_OPTIONS;

    switch (ptConfig->format) {
          case MAIN_DISPLAY_PLANE_FORMAT:
              break;
          default:
              tFail |= CLRCF_FORMAT;
    }

    if (ptFailed) *ptFailed = tFail;
    if (tFail) return DFB_UNSUPPORTED;

    return DFB_OK;
}

static DFBResult
shdfbMainDisplayAllocateSurface (CoreLayer *ptLayer,
			                        void *pvDriverData,
			                        void *pvLayerData,
			                        void *pvRegionData,
			                        CoreLayerRegionConfig *ptConfig,
			                        CoreSurface **ptRetSurface)
{
    DFBResult tRet;
    dShdfbDriverData_t *ptDriver = (dShdfbDriverData_t *) pvDriverData;
    CoreSurface *ptSurface;
    
    tRet =  tShdfbOldPrimaryFuncs.AllocateSurface (ptLayer, pShdfbOldPrimaryDriverData, pvLayerData, pvRegionData, ptConfig, ptRetSurface);
    if (tRet) {
    	return tRet;
    }

	ptSurface = *ptRetSurface;
#ifndef EMULATION
    ptSurface->front_buffer->system.addr = (void *) &ptDriver->tMainDisplayAddr;
    ptSurface->front_buffer->video.offset = 6;
#else    
    ptSurface->front_buffer->system.addr = (void *) ptDriver->tMainDisplayAddr.pdvAddr;
    fusion_reactor_attach (ptSurface->object.reactor, shdfbStopSurface, ptSurface, &ptDriver->reaction[ptDriver->reaction_num++]);
#endif     
    
    return DFB_OK;
}

DisplayLayerFuncs tShdfbMainDisplayFuncs = {
    LayerDataSize:      shdfbMainDisplaydatasize,
    InitLayer:          shdfbMainDisplayInitLayer,
    SetRegion:          shdfbSetRegion,
    RemoveRegion:        shdfbRemoveRegion,
    TestRegion:         shdfbMainDisplayTestRegion,
    AllocateSurface: shdfbMainDisplayAllocateSurface,
};
