/*
 * Copyright (c) 2005, 2006 Sharp Corporation
 */

#ifndef __SHDFB_GFX_H__
#define __SHDFB_GFX_H__

#include <core/coredefs.h>
#include <core/surfaces.h>
#include <core/layers.h>
#include <core/layer_control.h>

#include <directfb.h>

#include "lnxdfbc.h"

typedef struct _dShdfbDeviceData_t {
	void *pvSrcAddr;
	void *pvDestAddr;
	uint32 uiColor;
	bool bDisableAlpha;
	bool bDstAlphaFromSrc;
    dLnxDFBBlendType_e eBlendType;
    uint8 ucDestAlpha;
} dShdfbDeviceData_t;


typedef struct _dShdfbDriverData_t {
	dLnxDFBAddr_t tPrimaryAddr;
	dLnxDFBAddr_t tYUV_LAddr;
	dLnxDFBAddr_t tYUV_PAddr;
	dLnxDFBAddr_t tARGB_LAddr;
	dLnxDFBAddr_t tARGB_PAddr;
	dLnxDFBAddr_t tRotationAddr;
	dLnxDFBAddr_t tMainDisplayAddr;
#ifdef EMULATION   
	dLnxDFBAddr_t tARGBPortraitAddr;
    Reaction reaction[10];
    int reaction_num;
	CoreSurface *coreOfPrimarySurface;
#endif    
} dShdfbDriverData_t;

#define YUV_PLANE_FORMAT DSPF_UYVY

typedef struct _dShdfbYUVData_t {
	void *dummy;
} dShdfbYUVData_t;

#define ARGB_PLANE_FORMAT DSPF_ARGB

typedef struct _dShdfbARGBData_t {
	void *dummy;
} dShdfbARGBData_t;

DFBResult
shdfbSetRegion (CoreLayer *ptLayer,
              void *pDriver_data,
              void *pLayer_data,
              void *pRegion_data,
              CoreLayerRegionConfig *ptConfig,
              CoreLayerRegionConfigFlags tUpdated,
              CoreSurface *ptSurface,
              CorePalette *ptPalette);
              
DFBResult 
shdfbRemoveRegion (CoreLayer *ptLayer,
            void *pDriver_data,
            void *pLayer_data,
            void *pRegion_data);

DFBResult
shdfbReallocateSurface (CoreLayer *ptLayer,
			                        void *pvDriverData,
			                        void *pvLayerData,
			                        void *pvRegionData,
			                        CoreLayerRegionConfig *ptConfig,
			                        CoreSurface *ptSurface);
			                        
DFBResult
shdfbYUVAllocateSurface (CoreLayer *ptLayer,
			                        void *pvDriverData,
			                        void *pvLayerData,
			                        void *pvRegionData,
			                        CoreLayerRegionConfig *ptConfig,
			                        CoreSurface **ptRetSurface);
			                        
DFBResult
shdfbYUVTestRegion (CoreLayer *ptLayer,
                     void *pDriver_data,
                     void *pLayer_data,
                     CoreLayerRegionConfig      *ptConfig,
                     CoreLayerRegionConfigFlags *ptFailed);
                     
int shdfbYUVdatasize();

DFBResult
shdfbARGBAllocateSurface (CoreLayer *ptLayer,
			                        void *pvDriverData,
			                        void *pvLayerData,
			                        void *pvRegionData,
			                        CoreLayerRegionConfig *ptConfig,
			                        CoreSurface **ptRetSurface);
			                        
DFBResult
shdfbARGBTestRegion (CoreLayer *ptLayer,
                     void *pDriver_data,
                     void *pLayer_data,
                     CoreLayerRegionConfig      *ptConfig,
                     CoreLayerRegionConfigFlags *ptFailed);
                     
int shdfbARGBdatasize();

#ifdef EMULATION
ReactionResult 
shdfbDestroySurface ( const void *msg_data, void *ctx );

ReactionResult 
shdfbStopSurface ( const void *msg_data, void *ctx );
#endif

#endif  /* __SHDFB_GFX_H__ */
