/*
 * Copyright (c) 2005, 2006 Sharp Corporation
 */

#include <directfb.h>

#include <direct/messages.h>

#include <fusion/shmalloc.h>

#include <core/coretypes.h>
#include <core/gfxcard.h>
#include <core/graphics_driver.h>
#include <core/surfacemanager.h>
#include <core/system.h>
#include <core/screens.h>

#include <misc/conf.h>

#ifdef EMULATION
#include "stdlib.h"
#endif

#include "shdfb_gfx.h"
#include "shdfb_accel.h"

extern DisplayLayerFuncs tShdfbPrimaryFuncs;
extern DisplayLayerFuncs tShdfbYUVFuncs;
extern DisplayLayerFuncs tShdfbYUVPortraitFuncs;
extern DisplayLayerFuncs tShdfbARGBFuncs;
extern DisplayLayerFuncs tShdfbARGBPortraitFuncs;
extern DisplayLayerFuncs tShdfbRotationFuncs;
extern DisplayLayerFuncs tShdfbMainDisplayFuncs;
extern DisplayLayerFuncs  tShdfbOldPrimaryFuncs;
extern void *pShdfbOldPrimaryDriverData;

DFB_GRAPHICS_DRIVER (shdfb)

static int driver_probe (GraphicsDevice *ptDevice)
{
    return dfb_gfxcard_get_accelerator (ptDevice);
}

static void driver_get_info (GraphicsDevice *ptDevice,  GraphicsDriverInfo *ptInfo)
{
	snprintf (ptInfo->name, DFB_GRAPHICS_DRIVER_INFO_NAME_LENGTH, "SHDFB Driver");

    snprintf (ptInfo->vendor, DFB_GRAPHICS_DRIVER_INFO_VENDOR_LENGTH, "Sharp");

    snprintf(ptInfo->url, DFB_GRAPHICS_DRIVER_INFO_URL_LENGTH, "http://www.sharp.co.jp");

    snprintf(ptInfo->license, DFB_GRAPHICS_DRIVER_INFO_LICENSE_LENGTH, "Proprietry");

    ptInfo->version.major = 0;
    ptInfo->version.minor = 1;

    ptInfo->driver_data_size = sizeof (dShdfbDriverData_t);
    ptInfo->device_data_size = sizeof (dShdfbDeviceData_t);
}


static DFBResult driver_init_driver (GraphicsDevice *ptDevice,
                                    GraphicsDeviceFuncs *ptFuncs,
                                    void *pDriver_data,
                                    void *pDevice_data,
                                    CoreDFB *ptCore)
{
    ptFuncs->CheckState = shdfbCheckState;
    ptFuncs->SetState = shdfbSetState;
	ptFuncs->FillRectangle = shdfbFillRectangle;
    ptFuncs->Blit = shdfbBlit;
    ptFuncs->StretchBlit = shdfbStretchBlit;
    
    dfb_layers_hook_primary (ptDevice, pDriver_data, &tShdfbPrimaryFuncs,
			 	                             &tShdfbOldPrimaryFuncs, &pShdfbOldPrimaryDriverData);

    dfb_layers_register( dfb_screens_at(DSCID_PRIMARY), pDriver_data, &tShdfbYUVFuncs );
    dfb_layers_register( dfb_screens_at(DSCID_PRIMARY), pDriver_data, &tShdfbYUVPortraitFuncs );
    dfb_layers_register( dfb_screens_at(DSCID_PRIMARY), pDriver_data, &tShdfbARGBFuncs );
    dfb_layers_register( dfb_screens_at(DSCID_PRIMARY), pDriver_data, &tShdfbARGBPortraitFuncs );
    dfb_layers_register( dfb_screens_at(DSCID_PRIMARY), pDriver_data, &tShdfbRotationFuncs );
    dfb_layers_register( dfb_screens_at(DSCID_PRIMARY), pDriver_data, &tShdfbMainDisplayFuncs );

    return DFB_OK;
}

static DFBResult driver_init_device (GraphicsDevice *ptDevice,
                                    GraphicsDeviceInfo *ptDevice_info,
                                    void *pDriver_data,
                                    void *pDevice_data)
{
    snprintf (ptDevice_info->name, DFB_GRAPHICS_DEVICE_INFO_NAME_LENGTH, "SHDFB");
    snprintf (ptDevice_info->vendor, DFB_GRAPHICS_DEVICE_INFO_VENDOR_LENGTH, "Sharp");

    ptDevice_info->caps.accel = DFXL_FILLRECTANGLE | DFXL_BLIT;
    ptDevice_info->caps.flags = 0;
    ptDevice_info->caps.drawing  = 0;
    ptDevice_info->caps.blitting = 0;
    
    return DFB_OK;
}

static void driver_close_device(GraphicsDevice *device,
                                void *driver_data, void *device_data)
{
}

static void driver_close_driver(GraphicsDevice *device, void *driver_data)
{
}
