/*
 * Copyright (c) 2005, 2006 Sharp Corporation
 */

#include <direct/messages.h>

#include "shdfb_gfx.h"
#include "shdfb_accel.h"

bool shdfbFillRectangle (void  *pDriver_data, void *pDevice_data,  DFBRectangle *ptRect)
{
	dShdfbDeviceData_t *ptDevice = (dShdfbDeviceData_t *) pDevice_data;
	int32 iRet;
	
	if (ptDevice->bDisableAlpha) {
		ptDevice->uiColor |= 0xFF;
	};
	
	if (ptDevice->uiColor == 0) {
		return true;
	}

#ifndef EMULATION	
#if 0
	iRet = iLnxDFBFill (ptRect->x, ptRect->y, ptRect->w, ptRect->h, ptDevice->pvDestAddr, ptDevice->uiColor, &ptDevice->tDestImage);
#else
    iRet = iLnxDFBFill (ptRect->x, ptRect->y, ptRect->w, ptRect->h, ptDevice->pvDestAddr, ptDevice->uiColor);
#endif

#else
	iRet = 0;
#endif
    return iRet == 0;
}


bool shdfbGetBlitParam(dShdfbDeviceData_t *ptDevice, dLnxDFBBlendType_e *peBlendType, uint8 *pucDestAlpha)
{
#ifdef ENABLE_STP_VOD
	*pucDestAlpha = ucLnxDFBGetFillDstOpacity();	
#else /* ENABLE_STP_VOD */
	*pucDestAlpha = 0xff;
#endif /* ENABLE_STP_VOD */

	if (ptDevice->bDisableAlpha == true && ptDevice->bDstAlphaFromSrc == true) {
		*peBlendType = LNXDFB_PNG_MOVE ;
	} else 	if (ptDevice->bDisableAlpha == true && ptDevice->bDstAlphaFromSrc == false) {
		*peBlendType = LNXDFB_JPEG_MOVE ;
	} else 	if (ptDevice->bDisableAlpha == false && ptDevice->bDstAlphaFromSrc == true) {
		/* Invalid */
		return false;
	} else { /* ptDevice->bDisableAlpha == false && ptDevice->bDstAlphaFromSrc == false */
		if (*pucDestAlpha == 0xFF) {
            *peBlendType = LNXDFB_PNG_DRAW ;
		} else {
            *peBlendType = LNXDFB_RECT_DRAW ;
		}
	}
	return true;
}

bool shdfbBlit (void  *pDriver_data, void *pDevice_data,  DFBRectangle *ptRect, int32 iDx, int32 iDy)
{
	dShdfbDeviceData_t *ptDevice = (dShdfbDeviceData_t *) pDevice_data;
	int32 iRet;

#ifndef EMULATION	
    if (ptDevice->pvSrcAddr) {
		uint8 ucDestAlpha;
		dLnxDFBBlendType_e eBlendType;
		if (shdfbGetBlitParam(ptDevice, &eBlendType, &ucDestAlpha)) {
			iRet = iLnxDFBBlit (ptRect->x, ptRect->y, ptRect->w, ptRect->h, ptDevice->pvSrcAddr,
								iDx, iDy, ptRect->w, ptRect->h, ptDevice->pvDestAddr,
								eBlendType, ucDestAlpha);
		}
	}
#else
	iRet = 0;
#endif
    return iRet == 0;
}

bool shdfbStretchBlit (void  *pDriver_data, void *pDevice_data,  DFBRectangle *ptSrect, DFBRectangle *ptDrect)
{
	dShdfbDeviceData_t *ptDevice = (dShdfbDeviceData_t *) pDevice_data;
	int32 iRet;

#ifndef EMULAITON
	int32 fBlendAlpha = 0;
	int32 fDstAlphaFromSrc = 0;

	if (ptDevice->bDisableAlpha == false) {
		fBlendAlpha = 1;
	} else {
		fBlendAlpha = 0;
	}

	if (ptDevice->bDstAlphaFromSrc == true) {
		fDstAlphaFromSrc = 1;
	} else {
		fDstAlphaFromSrc = 0;
	}

	{
		uint8 ucDestAlpha;
		dLnxDFBBlendType_e eBlendType;
		if (shdfbGetBlitParam(ptDevice, &eBlendType, &ucDestAlpha)) {
			iRet = iLnxDFBBlit(ptSrect->x, ptSrect->y, ptSrect->w, ptSrect->h, ptDevice->pvSrcAddr,
							   ptDrect->x, ptDrect->y, ptDrect->w, ptDrect->h, ptDevice->pvDestAddr,
							   eBlendType, ucDestAlpha);
		}
	}
#else
	iRet = 0;
#endif
    return iRet == 0;
}

void shdfbCheckState (void *pDriver_data, void *pDevice_data, CardState *ptState, DFBAccelerationMask tAccel)
{
#ifndef EMULATION	
    dShdfbDriverData_t *ptDriver = (dShdfbDriverData_t *) pDriver_data;

    if (DFB_DRAWING_FUNCTION (tAccel)) {
    	if (tAccel & DFXL_FILLRECTANGLE) {
			ptState->accel |= DFXL_FILLRECTANGLE;
    	} 
    } else {
        /*TODO:addressindexˤб*/
		void *addr = ptState->source->front_buffer->system.addr;
 			
	    if (addr != &ptDriver->tPrimaryAddr && 
	    	addr != &ptDriver->tYUV_LAddr &&
	    	addr != &ptDriver->tYUV_PAddr &&
	    	addr != &ptDriver->tARGB_LAddr &&
	    	addr != &ptDriver->tARGB_PAddr &&
	    	addr != &ptDriver->tRotationAddr &&
	    	addr != &ptDriver->tMainDisplayAddr) {
	    	return;
	    }		

    	if (tAccel & DFXL_BLIT) {
	    	ptState->accel |= DFXL_BLIT;
    	} else if (tAccel & DFXL_STRETCHBLIT) {
	    	ptState->accel |= DFXL_STRETCHBLIT;
        }
    }
#endif    
}

void shdfbSetState (void *pDriver_data, void *pDevice_data, GraphicsDeviceFuncs *ptFuncs, CardState *ptState, DFBAccelerationMask tAccel)
{
#ifndef EMULATION	
	dShdfbDeviceData_t *ptDevice = (dShdfbDeviceData_t *) pDevice_data;
    dShdfbDriverData_t *ptDriver = (dShdfbDriverData_t *) pDriver_data;

 	if (DFB_DRAWING_FUNCTION (tAccel)) {
    	if (tAccel & DFXL_FILLRECTANGLE) {
 			void *addr = ptState->destination->front_buffer->system.addr;
	        ptFuncs->FillRectangle = shdfbFillRectangle;
            ptState->set = DFXL_FILLRECTANGLE;
		    ptDevice->uiColor = (uint32) ptState->color.a | ((uint32) ptState->color.b) << 8 | ((uint32) ptState->color.g) << 16 | ((uint32) ptState->color.r) <<24;
		    if (addr == &ptDriver->tMainDisplayAddr || addr == &ptDriver->tRotationAddr || ptState->blittingflags & DSBLIT_BLEND_ALPHACHANNEL) {
	    		/* ե֥ǥ󥰤ͭˤ */
	    		ptDevice->bDisableAlpha = false;
	    	} else {
	    		ptDevice->bDisableAlpha = true;
	    	}
		    ptDevice->pvDestAddr =addr;
    	}
 	} else {
 		if (tAccel & DFXL_BLIT) {
 			void *addr = ptState->source->front_buffer->system.addr;
			
	        ptFuncs->Blit = shdfbBlit;
		    ptState->set = DFXL_BLIT;
			ptDevice->pvSrcAddr = addr;

	    	ptDevice->pvDestAddr = ptState->destination->front_buffer->system.addr;

	    	if (ptState->blittingflags & DSBLIT_BLEND_ALPHACHANNEL) {
				if ((ptDevice->pvSrcAddr == &ptDriver->tYUV_LAddr) ||
					(ptDevice->pvSrcAddr == &ptDriver->tYUV_PAddr)) {
					ptDevice->bDisableAlpha = true;
				} else {
					/* ե֥ǥ󥰤ͭˤ */
					ptDevice->bDisableAlpha = false;
				}
	    	} else {
	    		ptDevice->bDisableAlpha = true;
	    	}

			if (ptState->blittingflags & DSBLIT_DSTALPHA_FROMSRC) {
				ptDevice->bDstAlphaFromSrc = true;
			} else {
				ptDevice->bDstAlphaFromSrc = false;
			}
		} else if (tAccel & DFXL_STRETCHBLIT) {
			ptFuncs->StretchBlit = shdfbStretchBlit;
		    ptState->set = DFXL_STRETCHBLIT;
		    ptDevice->pvSrcAddr = ptState->source->front_buffer->system.addr;
		    ptDevice->pvDestAddr = ptState->destination->front_buffer->system.addr;
			if (ptState->blittingflags & DSBLIT_BLEND_ALPHACHANNEL) {
				if ((ptDevice->pvSrcAddr == &ptDriver->tYUV_LAddr) ||
					(ptDevice->pvSrcAddr == &ptDriver->tYUV_PAddr)) {
					ptDevice->bDisableAlpha = true;
				} else {
					/* ե֥ǥ󥰤ͭˤ */
					ptDevice->bDisableAlpha = false;
				}
			} else {
				ptDevice->bDisableAlpha = true;
			}
			
			if (ptState->blittingflags & DSBLIT_DSTALPHA_FROMSRC) {
				ptDevice->bDstAlphaFromSrc = true;
			} else {
				ptDevice->bDstAlphaFromSrc = false;
			}
 		}
    }

    ptState->modified = 0;
#endif    
}
