/*
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include "config.h"
#include "CookieJar.h"
#include "NotImplemented.h"
#include "Cookie.h"
#include "Document.h"
#include "KURL.h"
#include "PlatformString.h"
#include "StringHash.h"
#include "ResourceHandleManager.h"
#include <wtf/HashMap.h>
#include <curl/curl.h>
#include <Vector.h>


namespace WebCore {

static ResourceHandleManager *cookieJar(const Document *document)
{
    if (!document)
        return 0;

    Frame *frame = document->frame();
    if (!frame)
        return 0;
    
    FrameLoader *loader = frame->loader();
    if (!loader)
        return 0;

    // TODO: Should check whether the cookies are enabled or not in this handle. Return NULL if it's disabled
    return ResourceHandleManager::sharedInstance();
}

void setCookies(Document* document, const KURL& url, const String& value)
{
    ResourceHandleManager* jar = cookieJar(document);
    if (jar && jar->cookieEnabled())
	    jar->setCookies(document, url, value);
}

String cookies(const Document* document, const KURL& url)
{
    ResourceHandleManager* jar = cookieJar(document);
    if (!jar || !jar->cookieEnabled())
        return String();
            
	return jar->cookies(document, url);
}

String cookieRequestHeaderFieldValue(const Document* document, const KURL& url)
{
    ResourceHandleManager* jar = cookieJar(document);
    if (!jar || !jar->cookieEnabled())
        return String();
            
	return jar->cookies(document, url);
}

bool cookiesEnabled(const Document* document)
{
    ResourceHandleManager* jar = cookieJar(document);
    if (!jar)
        return false;
   
    return jar->cookieEnabled();         
}

bool getRawCookies(const Document*, const KURL& url, Vector<Cookie>& rawCookies)
{	
    rawCookies.clear();
    
    return false; // return true when implemented
}

void deleteCookie(const Document*, const KURL& url, const String& name)
{
}

}
