/* -*- Mode: C; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is Mozilla Communicator client code.
 *
 * The Initial Developer of the Original Code is
 * Netscape Communications Corporation.
 * Portions created by the Initial Developer are Copyright (C) 1998
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 * Copyright (C) 2009, 2010, 2011 Espial Group Inc. All rights reserved.
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

#ifndef ARIBMNGIMAGEREADER_H_
#define ARIBMNGIMAGEREADER_H_

namespace WebCore
{

static const int MAX_HOLD_SIZE = 256;

struct AribMNGFrameChunk
{
	unsigned frameIndex;
	unsigned framingMode;
	unsigned subFrameName;
	unsigned changeInterframeDelay;
	unsigned changeSyncTimeout;
	unsigned changeSubFrameClipBounds;
	unsigned changeSyncId;
	unsigned interframeDelay;
	
	AribMNGFrameChunk()
	: frameIndex(0)
	, framingMode(0)
	, subFrameName(0)
	, changeInterframeDelay(0)
	, changeSyncTimeout(0)
	, changeSubFrameClipBounds(0)
	, changeSyncId(0)
	, interframeDelay(0)
	{		
	}
};

struct AribMNGImageReader {
    /* Parsing state machine */
    unsigned char hold[MAX_HOLD_SIZE]; /* Accumulation buffer */

    unsigned screen_width;       /* Logical screen width & height */
    unsigned screen_height;
    unsigned long ticks_per_sec;
    
    unsigned loop_count;

    /*TERM chunk*/
    unsigned terminationAction;

    /*FRAM chunk*/
    unsigned framingMode;

    Vector<unsigned> pngDataIndex;
    Vector<unsigned> pngDataLen;
    
    /*DEFI chunk*/
    unsigned xLocation, yLocation;

    AribMNGImageReader()
    : loop_count(0x7FFFFFFF)
    , m_defaultInterframeDelay(1)
    {
		screen_width = screen_height = 0;
		ticks_per_sec = 0;

		terminationAction = 0;

		framingMode = 0;

		xLocation = 0;
		yLocation = 0;
    }
    
    bool read(const unsigned char * buf, unsigned int numbytes);
    
    unsigned interframeDelay(int frameIndex) const;
    
    bool loopForever() const {
		return (loop_count == 0x7FFFFFFF);
	}
    
private:
    unsigned m_defaultInterframeDelay;

    Vector<AribMNGFrameChunk> frameChunks;
};

} //namespace WebCore

#endif /* ARIBMNGIMAGEREADER_H_ */
