/* -*- Mode: C; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is mozilla.org code.
 *
 * The Initial Developer of the Original Code is
 * Netscape Communications Corporation.
 * Portions created by the Initial Developer are Copyright (C) 1998
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *   Chris Saari <saari@netscape.com>
 *   Apple Computer
 *   Copyright (C) 2009, 2010, 2011 Espial Group Inc. All rights reserved.
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

/*
The Graphics Interchange Format(c) is the copyright property of CompuServe
Incorporated. Only CompuServe Incorporated is authorized to define, redefine,
enhance, alter, modify or change in any way the definition of the format.

CompuServe Incorporated hereby grants a limited, non-exclusive, royalty-free
license for the use of the Graphics Interchange Format(sm) in computer
software; computer software utilizing GIF(sm) must acknowledge ownership of the
Graphics Interchange Format and its Service Mark by CompuServe Incorporated, in
User and Technical Documentation. Computer software utilizing GIF, which is
distributed or may be distributed without User or Technical Documentation must
display to the screen or printer a message acknowledging ownership of the
Graphics Interchange Format and the Service Mark by CompuServe Incorporated; in
this case, the acknowledgement may be displayed in an opening screen or leading
banner, or a closing screen or trailing banner. A message such as the following
may be used:

    "The Graphics Interchange Format(c) is the Copyright property of
    CompuServe Incorporated. GIF(sm) is a Service Mark property of
    CompuServe Incorporated."

For further information, please contact :

    CompuServe Incorporated
    Graphics Technology Department
    5000 Arlington Center Boulevard
    Columbus, Ohio  43220
    U. S. A.

CompuServe Incorporated maintains a mailing list with all those individuals and
organizations who wish to receive copies of this document when it is corrected
or revised. This service is offered free of charge; please provide us with your
mailing address.
*/

#include "config.h"
#include "Vector.h"
#include "AribMNGImageReader.h"
#include <string.h>
#include <stdio.h>

// Define the Mozilla macro setup so that we can leave the macros alone.
#define PR_BEGIN_MACRO  do {
#define PR_END_MACRO    } while (0)

/*
 * GETN(n, s) requests at least 'n' bytes available from 'q', at start of state 's'
 *
 * Note, copied from GIF decoder. the hold will never need to be bigger than 256 bytes to gather up in the hold,
 * as each Arib MNG block can never be bigger than 256 bytes.
 * This buffer is only needed to copy left-over data from one GifWrite call to the next
 */
#define GETN(n,s)                \
  PR_BEGIN_MACRO                 \
    bytes_to_consume = (n);      \
    state = (s);                 \
    index = index + (n);         \
  PR_END_MACRO

/* Get a 16-bit value stored in little-endian format */
#define GETINT16(p)   ((p)[1]<<8|(p)[0])

namespace WebCore
{

/* Get a 32-bit value stored in little-endian format*/
static unsigned long toInt32(const unsigned char* p, int offset, int length){
	unsigned long value = 0;
   length += offset;
    for (int i = offset; i < length; i ++){
    	value += ((long)(p[i] & 0xff) << 8 * (length - 1 - i));
    }
   return (value);
}

typedef enum {
	mng_signature,
	mng_chunk,
	 mng_keyword,
    mng_mhdr,
    mng_mend,
    mng_term,
    mng_fram,
    mng_defi,
    mng_png_start,
    mng_png_end,
    mng_crc,
    mng_unknown,
    mng_done
} mngstate;


unsigned AribMNGImageReader::interframeDelay(int frameIndex) const
{
	unsigned delay = 0;
	
	for(unsigned i = 0; i < frameChunks.size(); ++i){
		if(frameChunks[i].frameIndex == frameIndex){
			delay = frameChunks[i].interframeDelay;
			break;
		}
	}
	
	if(delay == 0)
		delay = m_defaultInterframeDelay;
	
	return (delay > 0) ? delay : 1; 
}

/******************************************************************************/
/*
 * process data arriving from the stream for the mng decoder
 */

bool AribMNGImageReader::read(const unsigned char *buf, unsigned len)
{
	//fprintf(stderr,"AribMNGImageReader::read\n");
	//fprintf(stderr,"len = %d, query = %d \n", len, query);

  if (!len) {
    // No new data has come in since the last call, just ignore this call.
    return true;
  }
  
  int png_bytes;
  int index;

  mngstate state = mng_signature;
  unsigned bytes_to_consume = 8;         /* Number of bytes to accumulate */
  unsigned bytes_in_hold = 0;            /* bytes accumulated so far*/
  int chunklen = 0;
  bool inside_png = false;
  unsigned long crc = 0;
  
  char chunkname[4];

  const unsigned char *q = buf;

  // Add what we have so far to the block
  // If previous call to me left something in the hold first complete current block
  // Or if we are filling the colormaps, first complete the colormap
  unsigned char* p = 0;
  if (bytes_in_hold)
    p = hold;
  else
    p = 0;

  if (p) {
    // Add what we have sofar to the block
    unsigned l = len < bytes_to_consume ? len : bytes_to_consume;
    if (p)
        memcpy(p + bytes_in_hold, buf, l);

    if (l < bytes_to_consume) {
      // Not enough in 'buf' to complete current block, get more
      bytes_in_hold += l;
      bytes_to_consume -= l;
      
      return false;
    }
    // Reset hold buffer count
    bytes_in_hold = 0;
    // Point 'q' to complete block in hold (or in colormap)
    q = p;
  }

  // Invariant:
  //    'q' is start of current to be processed block (hold, colormap or buf)
  //    'bytes_to_consume' is number of bytes to consume from 'buf'
  //    'buf' points to the bytes to be consumed from the input buffer
  //    'len' is number of bytes left in input buffer from position 'buf'.
  //    At entrance of the for loop will 'buf' will be moved 'bytes_to_consume'
  //    to point to next buffer, 'len' is adjusted accordingly.
  //    So that next round in for loop, q gets pointed to the next buffer.

  for (;len >= bytes_to_consume; q=buf) {
    // Eat the current block from the buffer, q keeps pointed at current block
    buf += bytes_to_consume;
    len -= bytes_to_consume;

    //fprintf(stderr,"state = %d\n", state);

    switch (state)
    {
    case mng_signature: //0
    {
    	if (strncmp((char*)q, "\x8A\x4D\x4E\x47\x0D\x0A\x1A\x0A", 8))
		  return false;
    	
    	index = 8;
    	GETN(4, mng_chunk);
    }
    break;

    case mng_chunk: //1
    {
      crc = 0;
      //for (int i = 0; i < 4; i ++)
      //    fprintf(stderr,"q[%d] = %d,", i, q[i]);
      chunklen = toInt32(q, 0, 4);
      //fprintf(stderr,"chunk length = %d\n", chunklen);
      GETN(4, mng_keyword);
    }
    break;

    case mng_keyword: //2
    {
      //fprintf(stderr,"index = %d\n", index);
      strncpy(chunkname, (char*)q, 4);
      //fprintf(stderr,"mng_keyword  chunkname = %s\n", chunkname);
      if (!strncmp(chunkname, "MHDR", 4)){
     	  GETN(chunklen + 4, mng_mhdr);
     	  //fprintf(stderr,"MHDR\n");
      }else if(!strncmp(chunkname, "MEND", 4)){
    	  GETN(chunklen + 4, mng_mend);
    	  //fprintf(stderr,"MEND\n");
      }else if(!strncmp(chunkname, "TERM", 4)){
    	  GETN(chunklen + 4, mng_term);
    	  //fprintf(stderr,"TERM\n");
      }else if(!strncmp(chunkname, "FRAM", 4)){
    	  GETN(chunklen + 4, mng_fram);
    	  //fprintf(stderr,"FRAM\n");
      }else if(!strncmp(chunkname, "DEFI", 4)){
    	  GETN(chunklen + 4, mng_defi);
    	  //fprintf(stderr,"DEFI\n");
      }else if(!strncmp(chunkname, "IHDR", 4)){
    	  GETN(chunklen + 4, mng_png_start);
    	  //fprintf(stderr,"IHDR\n");
      }else if(!strncmp(chunkname, "IEND", 4)){
    	  GETN(chunklen + 4, mng_png_end);
    	  //fprintf(stderr,"IEND\n");
      }else{
    	  GETN(chunklen + 4, mng_unknown);
    	  //fprintf(stderr,"UNKNOWN\n");
        }
    }
    break;

    case mng_mhdr: //3
    {
      unsigned long width, height, tickspersec, nominallayercount, nominalframecount, nominalplaytime, simplicityprofile;

      /* --------------------- MHDR format  ---------------------*/
      /*Field Name               Byte Number            constrain*/
      /* Frame width             4                               */
      /* Frame height            4                               */
      /* Ticks per second        4                  other than 0 */
      /* Nominal layer count     4                             0 */
      /* Nominal frame count     4                             0 */
      /* Nominal play time       4                             0 */
      /* Simplicity profile      4                             0 */

      width = toInt32(q, 0, 4);
      height = toInt32(q, 4, 4);
      tickspersec = toInt32(q, 8, 4);
      nominallayercount = toInt32(q, 12, 4);
      nominalframecount = toInt32(q, 16, 4);
      nominalplaytime = toInt32(q, 20, 4);
      simplicityprofile = toInt32(q, 24, 4);

      //fprintf(stderr,"mng_mhdr ------------------------\n");
      //fprintf(stderr,"width = %d, height = %d, tickspersec = %d, nominallayercount = %d\n",
    	//	  width, height, tickspersec, nominallayercount);
      if (tickspersec == 0
    		  || nominallayercount != 0
    		  || nominalframecount != 0
    		  || nominalplaytime != 0
    		  || simplicityprofile != 0){
    	  return false;
      }

     png_bytes = 0;
     screen_height = height;
     screen_width = width;
     ticks_per_sec = tickspersec;

     GETN(4, mng_chunk);
    }
    break;

    case mng_term:
    {
		terminationAction = toInt32(q, 0, 1);
		unsigned actionAfterIteration = toInt32(q, 1, 1);
		unsigned delay = toInt32(q, 2, 4);
		loop_count = toInt32(q, 6, 4);
		//fprintf(stderr,"mng_term  terminationAction = %d\n", terminationAction);

		if (terminationAction != 3
				  || actionAfterIteration != 0
				  || delay != 0){
			return false;
		}
		//fprintf(stderr,"loop_count = %d\n", loop_count);
		GETN(4, mng_chunk);
    }
    break;

    case mng_fram:
    {
    	if (chunklen != 1 && chunklen != 10)
    	    return false;

    	AribMNGFrameChunk frameChunk;
    	
    	frameChunk.framingMode = toInt32(q, 0, 1);
    	//fprintf(stderr,"mng_fram  framingMode = %d\n", framingMode);

    	if (chunklen == 10){
    		frameChunk.subFrameName = toInt32(q, 1, 1);
    		frameChunk.changeInterframeDelay = toInt32(q, 2, 1);
    		frameChunk.changeSyncTimeout = toInt32(q, 3, 1);
    		frameChunk.changeSubFrameClipBounds = toInt32(q, 4, 1);
    		frameChunk.changeSyncId = toInt32(q, 5, 1);
    		frameChunk.interframeDelay = toInt32(q, 6, 4);
    		
    	   if (frameChunk.subFrameName != 0
				  || frameChunk.changeSyncTimeout != 0
				  || frameChunk.changeSubFrameClipBounds != 0
				  || frameChunk.changeSyncId != 0){
			return false;
		  }
    	}
    	
    	frameChunk.frameIndex = pngDataIndex.size();
    	
    	if(frameChunk.changeInterframeDelay == 2){//Yes, also reset default.
    		m_defaultInterframeDelay = frameChunk.interframeDelay;
    	}
    	
    	frameChunks.append(frameChunk);
    	
    	GETN(4, mng_chunk);
    }
    break;

    case mng_defi:
    {
    	unsigned objectID = toInt32(q, 0, 2);
    	unsigned nonDisplayFlag = toInt32(q, 2, 1);
    	unsigned concreteFlag = toInt32(q, 3, 1);
    	xLocation = toInt32(q, 4, 4);
    	yLocation = toInt32(q, 8, 4);
    	//fprintf(stderr,"mng_defi  xLocation = %d\n", xLocation);

    	if (objectID != 0
				  || nonDisplayFlag != 0
				  || concreteFlag != 0){
			return false;
		}
    	GETN(4, mng_chunk);
    }
    break;

    case mng_png_start:
    {
    	//fprintf(stderr,"mng_png_start\n");
    	inside_png = true;
    	
    	png_bytes = 8 + chunklen + 4;
    	pngDataIndex.append(index - 8 - chunklen - 4);

    	GETN(4, mng_chunk);
    }
    break;

    case mng_png_end:
   {
	   //fprintf(stderr,"mng_png_end\n");
		inside_png = false;
		png_bytes += 8 + chunklen + 4;
		pngDataLen.append(png_bytes);

		GETN(4, mng_chunk);
   }
   break;

    case mng_unknown:
    {
    	//fprintf(stderr,"mng_unknown\n");
    	/*If the unknown chunk is inside png frame, add it to pngData.
    	 * if not, ignore it.*/
    	if (inside_png ){
    		png_bytes += 8 + chunklen + 4;
    	}

    	GETN(4, mng_chunk);
    }
    break;

    case mng_mend:
      return true;

    // We shouldn't ever get here.
    default:
      break;
    }
  }

  // Copy the leftover into gs->hold
  bytes_in_hold = len;
  if (len) {
    // Add what we have sofar to the block
    unsigned char* p;

    p = hold;
    if (p)
      memcpy(p, buf, len);
    bytes_to_consume -= len;
  }

  return false;
}

} //namespace WebCore
