/*
 * Copyright (C) 2007, 2009 Apple Inc.  All rights reserved.
 * Copyright (C) 2007 Collabora Ltd. All rights reserved.
 * Copyright (C) 2007 Alp Toker <alp@atoker.com>
 * Copyright (C) 2009, 2010, 2011 Espial Group Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * aint with this library; see the file COPYING.LIB.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#ifndef MediaPlayerPrivateEvo_h
#define MediaPlayerPrivateEvo_h

#if ENABLE(VIDEO)

#include "MediaPlayerPrivate.h"
#include "OwnPtr.h"
#include "RefPtr.h"

namespace WebCore {

    class GraphicsContext;
    class IntSize;
    class IntRect;
    class String;
    
    class SubresourceLoader;
    class MediaPlayerEvo;
    

    class MediaPlayerPrivate : public MediaPlayerPrivateInterface {
    	friend class MediaPlayerEvo;
    	
    	public:
            static void registerMediaEngine(MediaEngineRegistrar);
            ~MediaPlayerPrivate();

            IntSize naturalSize() const;
            bool hasVideo() const;
            bool hasAudio() const;

            void load(const String &url);
            void cancelLoad();

            void play();
            void pause();

            bool paused() const;
            bool seeking() const;

            float duration() const;
            float currentTime() const;
            void seek(float);
            void setEndTime(float);

            void setRate(float);
            void setVolume(float);
            void setMuted(bool);

            int dataRate() const;

            MediaPlayer::NetworkState networkState() const;
            MediaPlayer::ReadyState readyState() const;

            PassRefPtr<TimeRanges> buffered() const;
            float maxTimeSeekable() const;
            unsigned bytesLoaded() const;
            bool totalBytesKnown() const;
            unsigned totalBytes() const;

            void setVisible(bool);
            void setSize(const IntSize&);

            void repaint();
            void paint(GraphicsContext*, const IntRect&);

            bool hasSingleSecurityOrigin() const;

            bool supportsFullscreen() const;

        private:
            MediaPlayerPrivate(MediaPlayer*);
            
            static MediaPlayerPrivateInterface* create(MediaPlayer* player);

            static void getSupportedTypes(HashSet<String>&);
            static MediaPlayer::SupportsType supportsType(const String& type, const String& codecs);
            static bool isAvailable() { return true; }
            
        private:
            MediaPlayer* m_player;
            float m_rate;
            double m_volume;
            bool m_visible;

            bool m_seeking;
            String m_url;
                        
            RefPtr<SubresourceLoader> m_subresourceLoader;
            OwnPtr<MediaPlayerEvo> m_mediaPlayerEvo;
    };
}

#endif
#endif
