/*
 * Copyright (C) 2006, 2007 Apple Inc.  All rights reserved.
 * Copyright (C) 2006 Michael Emmel mike.emmel@gmail.com
 * Copyright (C) 2007 Holger Hans Peter Freyther
 * Copyright (C) 2008 Christian Dywan <christian@imendio.com>
 * Copyright (C) 2008 Nuanti Ltd.
 * Copyright (C) 2009, 2010, 2011 Espial Group Inc. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY APPLE COMPUTER, INC. ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL APPLE COMPUTER, INC. OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY
 * OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include "config.h"
#include "LocalizedStrings.h"
#include "NotImplemented.h"
#include "PlatformString.h"
#include "MathExtras.h"
#include <stdio.h>


namespace WebCore {

String submitButtonDefaultLabel()
{
    return String("Submit");
}

String inputElementAltText()
{
    return String("Submit");
}

String resetButtonDefaultLabel()
{
    return String("Reset");
}

String searchableIndexIntroduction()
{
    return String("_Searchable Index");
}

String fileButtonChooseFileLabel()
{
    return String("Choose File");
}

String fileButtonNoFileSelectedLabel()
{
    return String("(None)");
}

String contextMenuItemTagOpenLinkInNewWindow()
{
    return String("Open Link in New _Window");
}

String contextMenuItemTagDownloadLinkToDisk()
{
    return String("_Download Linked File");
}

String contextMenuItemTagCopyLinkToClipboard()
{
    return String("Copy Link Loc_ation");
}

String contextMenuItemTagOpenImageInNewWindow()
{
    return String("Open _Image in New Window");
}

String contextMenuItemTagDownloadImageToDisk()
{
    return String("Sa_ve Image As");
}

String contextMenuItemTagCopyImageToClipboard()
{
    return String("Cop_y Image");
}

String contextMenuItemTagOpenFrameInNewWindow()
{
    return String("Open _Frame in New Window");
}

String contextMenuItemTagCopy()
{
    static String stockLabel = String("Tag Copy");
    return stockLabel;
}

String contextMenuItemTagDelete()
{
    static String stockLabel = String("Tag Delete");
    return stockLabel;
}

String contextMenuItemTagSelectAll()
{	
    static String stockLabel = String("Select _All");
    
    return stockLabel;
}

String contextMenuItemTagUnicode()
{
    return String("_Insert Unicode Control Character");
}

String contextMenuItemTagInputMethods()
{
    return String("Input _Methods");
}

String contextMenuItemTagGoBack()
{
    static String stockLabel = String("Tag Go Back");
    return stockLabel;
}

String contextMenuItemTagGoForward()
{
    static String stockLabel = String("Tag Go Forward");
    return stockLabel;
}

String contextMenuItemTagStop()
{
    static String stockLabel = String("Tag Stop");
    return stockLabel;
}

String contextMenuItemTagReload()
{
    return String("_Reload");
}

String contextMenuItemTagCut()
{
    static String stockLabel = String("Tag Cut");
    return stockLabel;
}

String contextMenuItemTagPaste()
{
    static String stockLabel = String("Tag Paste");
    return stockLabel;
}

String contextMenuItemTagNoGuessesFound()
{
    return String("No Guesses Found");
}

String contextMenuItemTagIgnoreSpelling()
{
    return String("_Ignore Spelling");
}

String contextMenuItemTagLearnSpelling()
{
    return String("_Learn Spelling");
}

String contextMenuItemTagSearchWeb()
{
    return String("_Search the Web");
}

String contextMenuItemTagLookUpInDictionary()
{
    return String("_Look Up in Dictionary");
}

String contextMenuItemTagOpenLink()
{
    return String("_Open Link");
}

String contextMenuItemTagIgnoreGrammar()
{
    return String("Ignore _Grammar");
}

String contextMenuItemTagSpellingMenu()
{
    return String("Spelling and _Grammar");
}

String contextMenuItemTagShowSpellingPanel(bool show)
{
    return String(show ? ("_Show Spelling and Grammar") : ("_Hide Spelling and Grammar"));
}

String contextMenuItemTagCheckSpelling()
{
    return String("_Check Document Now");
}

String contextMenuItemTagCheckSpellingWhileTyping()
{
    return String("Check Spelling While _Typing");
}

String contextMenuItemTagCheckGrammarWithSpelling()
{
    return String("Check _Grammar With Spelling");
}

String contextMenuItemTagFontMenu()
{
    return String("_Font");
}

String contextMenuItemTagBold()
{
    static String stockLabel = String("Tag Bold");
    return stockLabel;
}

String contextMenuItemTagItalic()
{
    static String stockLabel = String("Tag Italic");
    return stockLabel;
}

String contextMenuItemTagUnderline()
{
    static String stockLabel = String("Tag Underline");
    return stockLabel;
}

String contextMenuItemTagOutline()
{
    return String("_Outline");
}

String contextMenuItemTagInspectElement()
{
    return String("Inspect _Element");
}

String searchMenuNoRecentSearchesText()
{
    return String("No recent searches");
}

String searchMenuRecentSearchesText()
{
    return String("Recent searches");
}

String searchMenuClearRecentSearchesText()
{
    return String("_Clear recent searches");
}

String AXDefinitionListTermText()
{
    return String("term");
}

String AXDefinitionListDefinitionText()
{
    return String("definition");
}

String AXButtonActionVerb()
{
    return String("press");
}

String AXRadioButtonActionVerb()
{
    return String("select");
}

String AXTextFieldActionVerb()
{
    return String("activate");
}

String AXCheckedCheckBoxActionVerb()
{
    return String("uncheck");
}

String AXUncheckedCheckBoxActionVerb()
{
    return String("check");
}

String AXLinkActionVerb()
{
    return String("jump");
}

String AXMenuListPopupActionVerb()
{
    return String();
}

String AXMenuListActionVerb()
{
    return String();
}

String multipleFileUploadText(unsigned numberOfFiles)
{
    // FIXME: If this file gets localized, this should really be localized as one string with a wildcard for the number.
    return String::number(numberOfFiles) + String(" files");
}

String unknownFileSizeText()
{
    return String("Unknown");
}

String imageTitle(const String& filename, const IntSize& size)
{
    notImplemented();
    return String();
}

#if ENABLE(VIDEO)

String mediaElementLoadingStateText()
{
    return String::fromUTF8("Loading...");
}

String mediaElementLiveBroadcastStateText()
{
    return String::fromUTF8("Live Broadcast");
}

String localizedMediaControlElementString(const String& name)
{
    if (name == "AudioElement")
        return String::fromUTF8("audio element controller");
    if (name == "VideoElement")
        return String::fromUTF8("video element controller");
    if (name == "MuteButton")
        return String::fromUTF8("mute");
    if (name == "UnMuteButton")
        return String::fromUTF8("unmute");
    if (name == "PlayButton")
        return String::fromUTF8("play");
    if (name == "PauseButton")
        return String::fromUTF8("pause");
    if (name == "Slider")
        return String::fromUTF8("movie time");
    if (name == "SliderThumb")
        return String::fromUTF8("timeline slider thumb");
    if (name == "RewindButton")
        return String::fromUTF8("back 30 seconds");
    if (name == "ReturnToRealtimeButton")
        return String::fromUTF8("return to realtime");
    if (name == "CurrentTimeDisplay")
        return String::fromUTF8("elapsed time");
    if (name == "TimeRemainingDisplay")
        return String::fromUTF8("remaining time");
    if (name == "StatusDisplay")
        return String::fromUTF8("status");
    if (name == "FullscreenButton")
        return String::fromUTF8("fullscreen");
    if (name == "SeekForwardButton")
        return String::fromUTF8("fast forward");
    if (name == "SeekBackButton")
        return String::fromUTF8("fast reverse");

    ASSERT_NOT_REACHED();
    
    return String();
}

String localizedMediaControlElementHelpText(const String& name)
{
    if (name == "AudioElement")
        return String::fromUTF8("audio element playback controls and status display");
    if (name == "VideoElement")
        return String::fromUTF8("video element playback controls and status display");
    if (name == "MuteButton")
        return String::fromUTF8("mute audio tracks");
    if (name == "UnMuteButton")
        return String::fromUTF8("unmute audio tracks");
    if (name == "PlayButton")
        return String::fromUTF8("begin playback");
    if (name == "PauseButton")
        return String::fromUTF8("pause playback");
    if (name == "Slider")
        return String::fromUTF8("movie time scrubber");
    if (name == "SliderThumb")
        return String::fromUTF8("movie time scrubber thumb");
    if (name == "RewindButton")
        return String::fromUTF8("seek movie back 30 seconds");
    if (name == "ReturnToRealtimeButton")
        return String::fromUTF8("return streaming movie to real time");
    if (name == "CurrentTimeDisplay")
        return String::fromUTF8("current movie time in seconds");
    if (name == "TimeRemainingDisplay")
        return String::fromUTF8("number of seconds of movie remaining");
    if (name == "StatusDisplay")
        return String::fromUTF8("current movie status");
    if (name == "SeekBackButton")
        return String::fromUTF8("seek quickly back");
    if (name == "SeekForwardButton")
        return String::fromUTF8("seek quickly forward");
    if (name == "FullscreenButton")
        return String::fromUTF8("Play movie in fullscreen mode");

    ASSERT_NOT_REACHED();
    return String();
}

String localizedMediaTimeDescription(float time)
{
    if (!isfinite(time))
        return String::fromUTF8("indefinite time");
    
    const int tmpStrLen = 256;
    char tmpStr[tmpStrLen];

    int seconds = (int)fabsf(time);
    int days = seconds / (60 * 60 * 24);
    int hours = seconds / (60 * 60);
    int minutes = (seconds / 60) % 60;
    seconds %= 60;

    if (days) {
    	snprintf(tmpStr, tmpStrLen, "%d days %d hours %d minutes %d seconds", days, hours, minutes, seconds);
    }
    else if (hours) {
    	snprintf(tmpStr, tmpStrLen, "%d hours %d minutes %d seconds", hours, minutes, seconds);
    }
    else if (minutes) {
    	snprintf(tmpStr, tmpStrLen, "%d minutes %d seconds", minutes, seconds);
    }
    else{
    	snprintf(tmpStr, tmpStrLen, "%d seconds", seconds);
    }
        
	return String::fromUTF8(tmpStr);
}
#endif  // ENABLE(VIDEO)

String validationMessageValueMissingText()
{
    return String::fromUTF8("value missing");
}

String validationMessageTypeMismatchText()
{
    notImplemented();
    return String::fromUTF8("type mismatch");
}

String validationMessagePatternMismatchText()
{
    return String::fromUTF8("pattern mismatch");
}

String validationMessageTooLongText()
{
    return String::fromUTF8("too long");
}

String validationMessageRangeUnderflowText()
{
    return String::fromUTF8("range underflow");
}

String validationMessageRangeOverflowText()
{
    return String::fromUTF8("range overflow");
}

String validationMessageStepMismatchText()
{
    return String::fromUTF8("step mismatch");
}


String missingPluginText()
{
    return String::fromUTF8("Missing Plug-in");
}

String crashedPluginText()
{
    notImplemented();
    return String::fromUTF8("Plug-in Failure");
}


}
