/*
 * Copyright (C) 2006 Michael Emmel mike.emmel@gmail.com
 * Copyright (C) 2007 Christian Dywan <christian@twotoasts.de>
 * All rights reserved.
 * Copyright (C) 2009, 2010, 2011 Espial Group Inc. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY APPLE COMPUTER, INC. ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL APPLE COMPUTER, INC. OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY
 * OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include "config.h"
#include "CursorGtk.h"

#include "CursorHelper.h"
#include "NotImplemented.h"
#include <wtf/Assertions.h>

namespace WebCore {

static Cursor defaultCursor;
int gCursorType = 0; // EspialBrowserCursorType_POINTER

Cursor::Cursor(const Cursor& other)
    : m_impl(other.m_impl)
{
}

Cursor::Cursor(Image*, const IntPoint&)
{
    notImplemented();
}

Cursor::~Cursor()
{
}

Cursor& Cursor::operator=(const Cursor& other)
{
    return *this;
}

Cursor::Cursor(GdkCursor* c)
    : m_impl(c)
{
    m_impl = c;
}

const Cursor& pointerCursor()
{
	gCursorType = 0; // EspialBrowserCursorType_POINTER
    return defaultCursor;
}

const Cursor& crossCursor()
{
	gCursorType = 1; // EspialBrowserCursorType_CROSS
    return defaultCursor;
}

const Cursor& handCursor()
{
	gCursorType = 2; // EspialBrowserCursorType_HAND
    return defaultCursor;
}

const Cursor& moveCursor()
{
	gCursorType = 0;
    return defaultCursor;
}

const Cursor& iBeamCursor()
{
	gCursorType = 3; // EspialBrowserCursorType_IBEAM
    return defaultCursor;
}

const Cursor& waitCursor()
{
	gCursorType = 4; // EspialBrowserCursorType_WAIT
    return defaultCursor;
}

const Cursor& helpCursor()
{
	gCursorType = 5; // EspialBrowserCursorType_HELP
    return defaultCursor;
}

const Cursor& eastResizeCursor()
{
	gCursorType = 0;
    return defaultCursor;
}

const Cursor& northResizeCursor()
{
	gCursorType = 0;
    return defaultCursor;
}

const Cursor& northEastResizeCursor()
{
	gCursorType = 0;
    return defaultCursor;
}

const Cursor& northWestResizeCursor()
{
	gCursorType = 0;
    return defaultCursor;
}

const Cursor& southResizeCursor()
{
	gCursorType = 0;
    return defaultCursor;
}

const Cursor& southEastResizeCursor()
{
	gCursorType = 0;
    return defaultCursor;
}

const Cursor& southWestResizeCursor()
{
	gCursorType = 0;
    return defaultCursor;
}

const Cursor& westResizeCursor()
{
	gCursorType = 0;
    return defaultCursor;
}

const Cursor& northSouthResizeCursor()
{
	gCursorType = 0;
    return defaultCursor;
}

const Cursor& eastWestResizeCursor()
{
	gCursorType = 0;
    return defaultCursor;
}

const Cursor& northEastSouthWestResizeCursor()
{
	gCursorType = 0;
    return defaultCursor;
}

const Cursor& northWestSouthEastResizeCursor()
{
	gCursorType = 0;
    return defaultCursor;
}

const Cursor& columnResizeCursor()
{
	gCursorType = 0;
    return defaultCursor;
}

const Cursor& rowResizeCursor()
{
	gCursorType = 0;
    return defaultCursor;
}
    
const Cursor& middlePanningCursor()
{
	gCursorType = 0;
    return defaultCursor;
}

const Cursor& eastPanningCursor()
{
	gCursorType = 0;
    return defaultCursor;
}

const Cursor& northPanningCursor()
{
	gCursorType = 0;
    return defaultCursor;
}

const Cursor& northEastPanningCursor()
{
	gCursorType = 0;
    return defaultCursor;
}

const Cursor& northWestPanningCursor()
{
	gCursorType = 0;
    return defaultCursor;
}

const Cursor& southPanningCursor()
{
	gCursorType = 0;
    return defaultCursor;
}

const Cursor& southEastPanningCursor()
{
	gCursorType = 0;
    return defaultCursor;
}

const Cursor& southWestPanningCursor()
{
	gCursorType = 0;
    return defaultCursor;
}

const Cursor& westPanningCursor()
{
	gCursorType = 0;
    return defaultCursor;
}
    

const Cursor& verticalTextCursor()
{
	gCursorType = 0;
    return defaultCursor;
}

const Cursor& cellCursor()
{
	gCursorType = 0;
    return defaultCursor;
}

const Cursor& contextMenuCursor()
{
	gCursorType = 0;
    return defaultCursor;
}

const Cursor& noDropCursor()
{
	gCursorType = 0;
    return defaultCursor;
}

const Cursor& copyCursor()
{
	gCursorType = 0;
    return defaultCursor;
}

const Cursor& progressCursor()
{
	gCursorType = 0;
    return defaultCursor;
}

const Cursor& aliasCursor()
{
	gCursorType = 0;
    return defaultCursor;
}

const Cursor& noneCursor()
{
	gCursorType = 6; // EspialBrowserCursorType_NONE
    return defaultCursor;
}

const Cursor& notAllowedCursor()
{
	gCursorType = 0;
    return defaultCursor;
}

const Cursor& zoomInCursor()
{
	gCursorType = 0;
    return defaultCursor;
}

const Cursor& zoomOutCursor()
{
	gCursorType = 0;
    return defaultCursor;
}

const Cursor& grabCursor()
{
	gCursorType = 0;
    return defaultCursor;
}

const Cursor& grabbingCursor()
{
	gCursorType = 0;
    return defaultCursor;
}

}
