/*
 * Copyright (C) 1999 Lars Knoll (knoll@kde.org)
 *           (C) 1999 Antti Koivisto (koivisto@kde.org)
 *           (C) 2000 Simon Hausmann <hausmann@kde.org>
 * Copyright (C) 2003, 2006, 2009 Apple Inc. All rights reserved.
 * Copyright (C) 2009, 2010, 2011 Espial Group Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this library; see the file COPYING.LIB.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 *
 */

#ifndef HTMLBeitemElement_h
#define HTMLBeitemElement_h

#include "HTMLElement.h"

namespace WebCore {

class String;

class HTMLBeitemElement : public HTMLElement {
public:
    HTMLBeitemElement(const QualifiedName&, Document*);

    bool subscribe() const;
    unsigned short messageId() const;
    unsigned short messageVersion() const;
    unsigned short messageGroupId() const;
    unsigned short languageTag() const;
    unsigned short registerId() const;
    unsigned short serviceId() const;
    unsigned short eventId() const;
    			
    void setSubscribe(bool);
    void setMessageId(unsigned short);
    void setMessageVersion(unsigned short);
    void setMessageGroupId(unsigned short);
    void setLanguageTag(unsigned short);
    void setRegisterId(unsigned short);
    void setServiceId(unsigned short);
    void setEventId(unsigned short);
    
private:
    virtual HTMLTagStatus endTagRequirement() const { return TagStatusForbidden; }
    virtual int tagPriority() const { return 0; }
    

    virtual bool mapToEntry(const QualifiedName&, MappedAttributeEntry&) const;
    virtual void parseMappedAttribute(MappedAttribute*);
};

} //namespace

#endif
