/*
 *	Copyright (C) 2009-2011, Espial Group Inc. All rights reserved.
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this library; see the file COPYING.LIB.  If not, write to
 *  the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 *  Boston, MA 02110-1301, USA.
 *
 */
	
#ifndef CSSBMLValue_h
#define CSSBMLValue_h

#include "CSSValue.h"
#include <wtf/PassRefPtr.h>

namespace WebCore {

class CSSBMLValue : public CSSValue {
public:
    enum UnitBMLTypes {
    	CSS_BML_UNKONWN = 0,
    	CSS_BML_STRING = 1,
    };
    
    static PassRefPtr<CSSBMLValue> create(const String& value, UnitBMLTypes type)
    {
    	return adoptRef(new CSSBMLValue(value, type));
    }
    
    virtual ~CSSBMLValue()
    {
    }
    
    virtual String cssText() const { return m_cssText; }

private:    
	CSSBMLValue(const String& value, UnitBMLTypes type)
	: m_cssText(value)
	, m_type(type)
	{		
	}

private:
	const String m_cssText;
	const UnitBMLTypes m_type;
};

} // namespace WebCore

#endif // CSSBMLValue_h
