/*
 * Copyright (C) 2010 Espial Group Inc. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are
 * met:
 *
 *     * Redistributions of source code must retain the above copyright
 * notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above
 * copyright notice, this list of conditions and the following disclaimer
 * in the documentation and/or other materials provided with the
 * distribution.
 *     * Neither the name of Espial Group Inc. nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */



#ifndef MemoryMonitor_h
#define MemoryMonitor_h

#include <stdlib.h>

namespace JSC
{
class JSGlobalObject;
}

using JSC::JSGlobalObject;

namespace WTF
{

typedef bool (*jsMmapChecker)(JSGlobalObject* jsGlobalObject, size_t allocatedSize);

class JSMmapMonitor
{
public:	
	static JSMmapMonitor* instance() { return &gInstance; }
	
	void mmapStat(void* p, size_t size);
	void munmapStat(void* p, size_t size);
	
	size_t allocatedSize() const { return m_allocatedBytes; }

	size_t peekSize() const { return m_peekBytes; }
	
	bool canGrow(JSGlobalObject* jsGlobalObject) const
	{
		return (m_mmapChecker ? m_mmapChecker(jsGlobalObject, m_allocatedBytes) : true);
	}

	void setChecker(jsMmapChecker mmapChecker, bool debugOn)
	{
		m_mmapChecker = mmapChecker;
		m_debugOn = debugOn;
	}
	
	void resetPeekSize() { m_peekBytes = m_allocatedBytes; }
	
private:
	JSMmapMonitor()
	: m_allocatedBytes(0)
	, m_peekBytes(0)
	, m_mmapChecker(0)
	, m_debugOn(false)
	{
	}
	
	static JSMmapMonitor gInstance;
	
	size_t m_allocatedBytes;
	size_t m_peekBytes;
	jsMmapChecker m_mmapChecker;
	bool m_debugOn;
};

}

#endif //MemoryMonitor_h
