/*
 *  Copyright (C) 2010 Espial Group Inc. All rights reserved.
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this library; see the file COPYING.LIB.  If not, write to
 *  the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 *  Boston, MA 02110-1301, USA.
 *
 */

#ifndef JSObjectBridge_h
#define JSObjectBridge_h

#include "JSObject.h"
#include "InternalFunction.h"

namespace JSC
{

class ExecState;
class Identifier;

class JSObjectBridge : public JSObject
{
public:
    JSObjectBridge(ExecState* exec);
    
    virtual ~JSObjectBridge();
    
    virtual bool getOwnPropertySlot(ExecState*, const Identifier& propertyName, PropertySlot&);
    virtual void putWithAttributes(ExecState*, const Identifier& propertyName, JSValue value, unsigned attributes);    
};

class InternalFunctionBridge : public InternalFunction
{
public:
	InternalFunctionBridge(ExecState* exec, const Identifier& iden);
	InternalFunctionBridge(ExecState* exec, const char* name);
	
    const UString& name(ExecState*);
    
    virtual ~InternalFunctionBridge();
    
};

}

#endif

