/*
 *  Copyright (C) 2010 Espial Group Inc. All rights reserved.
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this library; see the file COPYING.LIB.  If not, write to
 *  the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 *  Boston, MA 02110-1301, USA.
 *
 */

#include "config.h"
#include "JSObjectBridge.h"
#include "JSGlobalObject.h"

namespace JSC
{

JSObjectBridge::JSObjectBridge(ExecState* exec)
: JSObject(exec->lexicalGlobalObject()->callbackObjectStructure())
{
}

JSObjectBridge::~JSObjectBridge()
{	
}

bool JSObjectBridge::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
	return JSObject::getOwnPropertySlot(exec, propertyName, slot);
}

void JSObjectBridge::putWithAttributes(ExecState* exec, const Identifier& propertyName, JSValue value, unsigned attributes)
{
	JSObject::putWithAttributes(exec, propertyName, value, attributes);
}        

InternalFunctionBridge::InternalFunctionBridge(ExecState* exec, const Identifier& iden)
: InternalFunction(&exec->globalData(), exec->lexicalGlobalObject()->callbackFunctionStructure(), iden)
{
}

InternalFunctionBridge::InternalFunctionBridge(ExecState* exec, const char* name)
: InternalFunction(&exec->globalData(), exec->lexicalGlobalObject()->callbackFunctionStructure(), Identifier(exec, name))
{
}

InternalFunctionBridge::~InternalFunctionBridge()
{
}

const UString& InternalFunctionBridge::name(ExecState* exec)
{
	return InternalFunction::name(exec);
}

}
